<?php
/**
 * PublicSubscriptionStatus
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\CommunicationPreferences
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Subscriptions
 *
 * Subscriptions allow contacts to control what forms of communications they receive. Contacts can decide whether they want to receive communication pertaining to a specific topic, brand, or an entire HubSpot account.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\CommunicationPreferences\Model;

use \ArrayAccess;
use \HubSpot\Client\CommunicationPreferences\ObjectSerializer;

/**
 * PublicSubscriptionStatus Class Doc Comment
 *
 * @category Class
 * @description The status of a subscription for a contact.
 * @package  HubSpot\Client\CommunicationPreferences
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PublicSubscriptionStatus implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PublicSubscriptionStatus';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'brand_id' => 'int',
        'name' => 'string',
        'description' => 'string',
        'legal_basis' => 'string',
        'preference_group_name' => 'string',
        'id' => 'string',
        'legal_basis_explanation' => 'string',
        'status' => 'string',
        'source_of_status' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'brand_id' => 'int64',
        'name' => null,
        'description' => null,
        'legal_basis' => null,
        'preference_group_name' => null,
        'id' => null,
        'legal_basis_explanation' => null,
        'status' => null,
        'source_of_status' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'brand_id' => false,
        'name' => false,
        'description' => false,
        'legal_basis' => false,
        'preference_group_name' => false,
        'id' => false,
        'legal_basis_explanation' => false,
        'status' => false,
        'source_of_status' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'brand_id' => 'brandId',
        'name' => 'name',
        'description' => 'description',
        'legal_basis' => 'legalBasis',
        'preference_group_name' => 'preferenceGroupName',
        'id' => 'id',
        'legal_basis_explanation' => 'legalBasisExplanation',
        'status' => 'status',
        'source_of_status' => 'sourceOfStatus'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'brand_id' => 'setBrandId',
        'name' => 'setName',
        'description' => 'setDescription',
        'legal_basis' => 'setLegalBasis',
        'preference_group_name' => 'setPreferenceGroupName',
        'id' => 'setId',
        'legal_basis_explanation' => 'setLegalBasisExplanation',
        'status' => 'setStatus',
        'source_of_status' => 'setSourceOfStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'brand_id' => 'getBrandId',
        'name' => 'getName',
        'description' => 'getDescription',
        'legal_basis' => 'getLegalBasis',
        'preference_group_name' => 'getPreferenceGroupName',
        'id' => 'getId',
        'legal_basis_explanation' => 'getLegalBasisExplanation',
        'status' => 'getStatus',
        'source_of_status' => 'getSourceOfStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const LEGAL_BASIS_LEGITIMATE_INTEREST_PQL = 'LEGITIMATE_INTEREST_PQL';
    public const LEGAL_BASIS_LEGITIMATE_INTEREST_CLIENT = 'LEGITIMATE_INTEREST_CLIENT';
    public const LEGAL_BASIS_PERFORMANCE_OF_CONTRACT = 'PERFORMANCE_OF_CONTRACT';
    public const LEGAL_BASIS_CONSENT_WITH_NOTICE = 'CONSENT_WITH_NOTICE';
    public const LEGAL_BASIS_NON_GDPR = 'NON_GDPR';
    public const LEGAL_BASIS_PROCESS_AND_STORE = 'PROCESS_AND_STORE';
    public const LEGAL_BASIS_LEGITIMATE_INTEREST_OTHER = 'LEGITIMATE_INTEREST_OTHER';
    public const STATUS_SUBSCRIBED = 'SUBSCRIBED';
    public const STATUS_NOT_SUBSCRIBED = 'NOT_SUBSCRIBED';
    public const SOURCE_OF_STATUS_PORTAL_WIDE_STATUS = 'PORTAL_WIDE_STATUS';
    public const SOURCE_OF_STATUS_BRAND_WIDE_STATUS = 'BRAND_WIDE_STATUS';
    public const SOURCE_OF_STATUS_SUBSCRIPTION_STATUS = 'SUBSCRIPTION_STATUS';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getLegalBasisAllowableValues()
    {
        return [
            self::LEGAL_BASIS_LEGITIMATE_INTEREST_PQL,
            self::LEGAL_BASIS_LEGITIMATE_INTEREST_CLIENT,
            self::LEGAL_BASIS_PERFORMANCE_OF_CONTRACT,
            self::LEGAL_BASIS_CONSENT_WITH_NOTICE,
            self::LEGAL_BASIS_NON_GDPR,
            self::LEGAL_BASIS_PROCESS_AND_STORE,
            self::LEGAL_BASIS_LEGITIMATE_INTEREST_OTHER,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_SUBSCRIBED,
            self::STATUS_NOT_SUBSCRIBED,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSourceOfStatusAllowableValues()
    {
        return [
            self::SOURCE_OF_STATUS_PORTAL_WIDE_STATUS,
            self::SOURCE_OF_STATUS_BRAND_WIDE_STATUS,
            self::SOURCE_OF_STATUS_SUBSCRIPTION_STATUS,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('brand_id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('legal_basis', $data ?? [], null);
        $this->setIfExists('preference_group_name', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('legal_basis_explanation', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('source_of_status', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['description'] === null) {
            $invalidProperties[] = "'description' can't be null";
        }
        $allowedValues = $this->getLegalBasisAllowableValues();
        if (!is_null($this->container['legal_basis']) && !in_array($this->container['legal_basis'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'legal_basis', must be one of '%s'",
                $this->container['legal_basis'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['source_of_status'] === null) {
            $invalidProperties[] = "'source_of_status' can't be null";
        }
        $allowedValues = $this->getSourceOfStatusAllowableValues();
        if (!is_null($this->container['source_of_status']) && !in_array($this->container['source_of_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'source_of_status', must be one of '%s'",
                $this->container['source_of_status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets brand_id
     *
     * @return int|null
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param int|null $brand_id The ID of the brand that the subscription is associated with, if there is one.
     *
     * @return self
     */
    public function setBrandId($brand_id)
    {
        if (is_null($brand_id)) {
            throw new \InvalidArgumentException('non-nullable brand_id cannot be null');
        }
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The name of the subscription.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description A description of the subscription.
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets legal_basis
     *
     * @return string|null
     */
    public function getLegalBasis()
    {
        return $this->container['legal_basis'];
    }

    /**
     * Sets legal_basis
     *
     * @param string|null $legal_basis The legal reason for the current status of the subscription.
     *
     * @return self
     */
    public function setLegalBasis($legal_basis)
    {
        if (is_null($legal_basis)) {
            throw new \InvalidArgumentException('non-nullable legal_basis cannot be null');
        }
        $allowedValues = $this->getLegalBasisAllowableValues();
        if (!in_array($legal_basis, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'legal_basis', must be one of '%s'",
                    $legal_basis,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['legal_basis'] = $legal_basis;

        return $this;
    }

    /**
     * Gets preference_group_name
     *
     * @return string|null
     */
    public function getPreferenceGroupName()
    {
        return $this->container['preference_group_name'];
    }

    /**
     * Sets preference_group_name
     *
     * @param string|null $preference_group_name The name of the preferences group that the subscription is associated with.
     *
     * @return self
     */
    public function setPreferenceGroupName($preference_group_name)
    {
        if (is_null($preference_group_name)) {
            throw new \InvalidArgumentException('non-nullable preference_group_name cannot be null');
        }
        $this->container['preference_group_name'] = $preference_group_name;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id The ID for the subscription.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets legal_basis_explanation
     *
     * @return string|null
     */
    public function getLegalBasisExplanation()
    {
        return $this->container['legal_basis_explanation'];
    }

    /**
     * Sets legal_basis_explanation
     *
     * @param string|null $legal_basis_explanation A more detailed explanation to go with the legal basis.
     *
     * @return self
     */
    public function setLegalBasisExplanation($legal_basis_explanation)
    {
        if (is_null($legal_basis_explanation)) {
            throw new \InvalidArgumentException('non-nullable legal_basis_explanation cannot be null');
        }
        $this->container['legal_basis_explanation'] = $legal_basis_explanation;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string $status Whether the contact is subscribed.
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $allowedValues = $this->getStatusAllowableValues();
        if (!in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets source_of_status
     *
     * @return string
     */
    public function getSourceOfStatus()
    {
        return $this->container['source_of_status'];
    }

    /**
     * Sets source_of_status
     *
     * @param string $source_of_status Where the status is determined from e.g. PORTAL_WIDE_STATUS if the contact opted out from the portal.
     *
     * @return self
     */
    public function setSourceOfStatus($source_of_status)
    {
        if (is_null($source_of_status)) {
            throw new \InvalidArgumentException('non-nullable source_of_status cannot be null');
        }
        $allowedValues = $this->getSourceOfStatusAllowableValues();
        if (!in_array($source_of_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'source_of_status', must be one of '%s'",
                    $source_of_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['source_of_status'] = $source_of_status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


